// C Signal Generator Example

#include <string.h>
#include <stdio.h>
#include "ap_comm_lib.h"

#define DEVICES_BUFFER_SIZE 1000
#define BUFFER_SIZE 1000
#define MAX_DEVICES 20

int main(void)
{
	char* str;
	char* device[MAX_DEVICES];
	char devices[DEVICES_BUFFER_SIZE];
	int nDevices;
	int retCount;
	int selection;
	char* address;
	int linkId;
	char buffer[BUFFER_SIZE];

	ap_comm_loadVisa();

	ap_comm_find(devices,
		         1000,
				 DEVICES_BUFFER_SIZE,
				 NULL,
				 AP_COMM_IFACE_LAN|AP_COMM_IFACE_USB|AP_COMM_IFACE_VISA_GPIB);

	// Print devices list
	printf("Devices list:\n");
	str = devices;
	for (nDevices=0; nDevices<MAX_DEVICES; nDevices++) {
		device[nDevices] = str;
		str = strchr( str, ';' );
		if (str!=NULL) {
			str[0] = '\0';
			str++;
		} else {
			break;
		}
		printf("  %d %s\n", nDevices, device[nDevices]);
	}
	// Return if no devices foun
	if (nDevices==0) {
		printf("No devices found\n");
		getchar();
		ap_comm_freeVisa();
		return 0;
	}

	// Let user select a device
	printf("Select a device: ");
	scanf_s( "%d", &selection );
	getchar();
	// Skip model within device string
	if (selection<nDevices) {
		str = strchr( device[selection], ':' );
	}
	// Skip serial number within device string
	if (str!=NULL) {
		str = strchr( str+1, ':' );
	}
	// Get address
	if (str!=NULL) {
		address = str+1;
	}
	
	// Open link
	ap_comm_open(address, 2000, &linkId);

	// Query "*IDN?"
	ap_comm_puts(linkId, "*IDN?\n", 0, NULL);
	ap_comm_gets(linkId, buffer, BUFFER_SIZE, NULL);
	printf("*IDN? response:\n  %s\n", buffer);

	// Send sweep list
	sprintf_s(buffer,
		      BUFFER_SIZE,
			  "11e6;0.0;1.0;1.0\n"
			  "22e6;0.0;1.0;1.0\n"
			  "33e6;0.0;1.0;1.0\n"
			  "44e6;0.0;1.0;1.0\n"
			  "55e6;0.0;1.0;1.0\n");
	ap_comm_writeBlock(linkId, "MEM:FILE:LIST:DATA\n", buffer, strlen(buffer));

	// Query sent list's number of points
	ap_comm_puts(linkId, "LIST:CURR:POIN?\n", 0, NULL);
	ap_comm_gets(linkId, buffer, BUFFER_SIZE, NULL);
	printf("Device received %s points list\n\n", buffer);

	// Receive processed sweep list
	ap_comm_readBlock(linkId, "MEM:FILE:LIST:DATA?\n", buffer, BUFFER_SIZE, &retCount);
	buffer[retCount] = '\0';
	printf("Processed list data:\n%s", buffer);

	// Close link
	ap_comm_close(linkId);
	ap_comm_freeVisa();
	getchar();
	return 0;
}
